Imports System.Data.SqlClient

Public Class Form1
    Inherits System.Windows.Forms.Form

    Private custGrid As System.Windows.Forms.DataGrid
    Private inventoryGrid As System.Windows.Forms.DataGrid
    Private WithEvents btnUpdate As System.Windows.Forms.Button
    Private OrdersGrid As System.Windows.Forms.DataGrid

    ' Voici la connexion.
    Private cn As SqlConnection = New SqlConnection("server=(local);uid=sa;pwd=;database=Cars;Integrated Security=SSPI")

    ' Notre adaptateur de donnes (pour chaque table).
    Private invTableAdapter As SqlDataAdapter
    Private custTableAdapter As SqlDataAdapter
    Private ordersTableAdapter As SqlDataAdapter

    ' Constructeur de commandes.
    Private invBuilder As SqlCommandBuilder = New SqlCommandBuilder()
    Private orderBuilder As SqlCommandBuilder = New SqlCommandBuilder()
    Private custBuilder As SqlCommandBuilder = New SqlCommandBuilder()

    ' L'objet DataSet.
    Private carsDS As DataSet = New DataSet("Cars")

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        cn.Open()

        ' Crer les adaptateurs.
        Try

            invTableAdapter = New SqlDataAdapter("Select * from Inventory", cn)
            custTableAdapter = New SqlDataAdapter("Select * from Customer", cn)
            ordersTableAdapter = New SqlDataAdapter("Select * from Orders", cn)
        Catch e As Exception
            MessageBox.Show(e.Message)
        End Try

        ' Commandes auto-gnres.
        invBuilder = New SqlCommandBuilder(invTableAdapter)
        orderBuilder = New SqlCommandBuilder(ordersTableAdapter)
        custBuilder = New SqlCommandBuilder(custTableAdapter)

        ' Remplir les tables.
        Try

            invTableAdapter.Fill(carsDS, "Inventory")
            ordersTableAdapter.Fill(carsDS, "Orders")
            custTableAdapter.Fill(carsDS, "Customer")
        Catch e As Exception
            MessageBox.Show(e.Message)
        End Try

        ' Construire des relations.
        BuildTableRelationship()

    End Sub

    'La classe Form surcharge la mthode dispose pour nettoyer la liste de composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
        cn.Close()
    End Sub

    'Requis par le Concepteur Windows Form
    Private components As System.ComponentModel.Container

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.OrdersGrid = New System.Windows.Forms.DataGrid()
        Me.inventoryGrid = New System.Windows.Forms.DataGrid()
        Me.custGrid = New System.Windows.Forms.DataGrid()
        Me.btnUpdate = New System.Windows.Forms.Button()
        CType(Me.OrdersGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.inventoryGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.custGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'OrdersGrid
        '
        Me.OrdersGrid.CaptionFont = New System.Drawing.Font("Microsoft Sans Serif", 8!)
        Me.OrdersGrid.CaptionText = "Commandes"
        Me.OrdersGrid.DataMember = ""
        Me.OrdersGrid.Location = New System.Drawing.Point(16, 256)
        Me.OrdersGrid.Name = "OrdersGrid"
        Me.OrdersGrid.Size = New System.Drawing.Size(336, 104)
        Me.OrdersGrid.TabIndex = 1
        '
        'inventoryGrid
        '
        Me.inventoryGrid.CaptionFont = New System.Drawing.Font("Microsoft Sans Serif", 8!)
        Me.inventoryGrid.CaptionText = "Inventaire"
        Me.inventoryGrid.DataMember = ""
        Me.inventoryGrid.Location = New System.Drawing.Point(16, 16)
        Me.inventoryGrid.Name = "inventoryGrid"
        Me.inventoryGrid.Size = New System.Drawing.Size(336, 104)
        Me.inventoryGrid.TabIndex = 0
        '
        'custGrid
        '
        Me.custGrid.CaptionFont = New System.Drawing.Font("Microsoft Sans Serif", 8!)
        Me.custGrid.CaptionText = "Clients"
        Me.custGrid.DataMember = ""
        Me.custGrid.Location = New System.Drawing.Point(16, 136)
        Me.custGrid.Name = "custGrid"
        Me.custGrid.Size = New System.Drawing.Size(336, 104)
        Me.custGrid.TabIndex = 1
        '
        'btnUpdate
        '
        Me.btnUpdate.Location = New System.Drawing.Point(16, 384)
        Me.btnUpdate.Name = "btnUpdate"
        Me.btnUpdate.TabIndex = 2
        Me.btnUpdate.Text = "Mise  jour"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(371, 440)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.btnUpdate, Me.OrdersGrid, Me.custGrid, Me.inventoryGrid})
        Me.Name = "Form1"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "DataSet  tables multiples "
        CType(Me.OrdersGrid, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.inventoryGrid, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.custGrid, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region
    Private Sub BuildTableRelationship()

        ' Crer un objet DataRelation.
        Dim dr As DataRelation = New DataRelation("CustomerOrder", _
        carsDS.Tables("Customer").Columns("CustID"), _
         carsDS.Tables("Orders").Columns("CustID"))

        ' L'ajouter au DataSet.
        carsDS.Relations.Add(dr)

        ' Crer un autre objet DataRelation.
        dr = New DataRelation("InventoryOrder", _
           carsDS.Tables("Inventory").Columns("CarID"), _
           carsDS.Tables("Orders").Columns("CarID"))

        ' L'ajouter au DataSet.
        carsDS.Relations.Add(dr)

        ' Remplir les grilles!
        inventoryGrid.SetDataBinding(carsDS, "Inventory")
        custGrid.SetDataBinding(carsDS, "Customer")
        OrdersGrid.SetDataBinding(carsDS, "Orders")
    End Sub

    Private Sub btnUpdate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
        Try
            invTableAdapter.Update(carsDS, "Inventory")
            custTableAdapter.Update(carsDS, "Customer")
            ordersTableAdapter.Update(carsDS, "Orders")
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub
End Class
